package game;

import java.io.BufferedReader;
import java.io.IOException;


public class EnemySpawnPoint {
	
	private int behavior = -1;
	
	private int xPos = -1;
	private int yPos = -1;
	private int maxX = -1;
	private int minX = -1;
	private int minY = -1;
	private int maxY = -1;
	
	private char dir = 'l';
	
	
	private EnemySpawnPoint() {
		
	}
	
	public static EnemySpawnPoint readFromReader(BufferedReader in) throws IOException {
		
		EnemySpawnPoint returnValue = new EnemySpawnPoint();
		
		String inputter = null;
		
		try {
			while((inputter = in.readLine()) != null) {
				
				if(inputter.contains("/enemy"))
					break;
				else if(inputter.contains("x:")) {
					returnValue.xPos = Integer.parseInt(inputter.substring(2).trim());
				} else if(inputter.contains("y:")) {
					returnValue.yPos = Integer.parseInt(inputter.substring(2).trim());
				} else if(inputter.contains("gray")) {
					returnValue.behavior = EnemySprite.LEFT_RIGHT;
				} else if(inputter.contains("green")) {
					returnValue.behavior = EnemySprite.UP_DOWN;
				} else if(inputter.contains("red")) {
					returnValue.behavior = EnemySprite.STATIONARY;
				} else if(inputter.contains("blue")) {
					returnValue.behavior = EnemySprite.TURRET;
				} else if(inputter.contains("yellow")) {
					returnValue.behavior = EnemySprite.LIGHTNING;
				} else if(inputter.contains("purple")) {
					returnValue.behavior = EnemySprite.UP_DOWN_TURRET;
				} else if(inputter.contains("maxX:")) {
					returnValue.maxX = Integer.parseInt(inputter.substring(5).trim());
				} else if(inputter.contains("maxY:")) {
					returnValue.maxY = Integer.parseInt(inputter.substring(5).trim());
				} else if(inputter.contains("minX:")) {
					returnValue.minX = Integer.parseInt(inputter.substring(5).trim());
				} else if(inputter.contains("minY:")) {
					returnValue.minY = Integer.parseInt(inputter.substring(5).trim());
				} else if(inputter.contains("dir:")) {
					returnValue.dir = inputter.charAt(4);
				}
				
			}
		} catch (NumberFormatException nfe) {
//			nfe.printStackTrace();
			return null;
		} catch (IndexOutOfBoundsException ioobe) {
//			ioobe.printStackTrace();
			return null;
		}
		
		if(returnValue.xPos == -1 || returnValue.yPos == -1) {
//			System.out.println("xpos/ypos not set, returning error");
			return null;
		}
		
		switch(returnValue.behavior) {
		case -1:
		default:
			System.out.println("behavior was an error type: " + returnValue.behavior);
			return null;
		case EnemySprite.LEFT_RIGHT:
		case EnemySprite.LIGHTNING:
			if(returnValue.maxX == -1 || returnValue.minX == -1) {
//				System.out.println("maxX/minX not set for type " + returnValue.behavior);
				return null;
			}
			break;
		case EnemySprite.UP_DOWN:
		case EnemySprite.UP_DOWN_TURRET:
			if(returnValue.minY == -1 || returnValue.maxY == -1) {
//				System.out.println("maxY/minY not set for type " + returnValue.behavior);
				return null;
			}
			break;
		case EnemySprite.STATIONARY:
		case EnemySprite.TURRET:
		}
		
		return returnValue;
		
	}

	public int getBehavior() {
		return behavior;
	}

	public int getxPos() {
		return xPos;
	}

	public int getyPos() {
		return yPos;
	}

	public int getMaxX() {
		return maxX;
	}

	public int getMinX() {
		return minX;
	}

	public int getMinY() {
		return minY;
	}

	public int getMaxY() {
		return maxY;
	}
	
	public char getDir() {
		return dir;
	}
	
	
}
